<?php

use App\Http\Controllers\CommuneController;
use App\Http\Controllers\FamilleController;
use App\Http\Controllers\MembreController;
use App\Http\Controllers\NiveauController;
use App\Http\Controllers\UserController;
use App\Http\Middleware\EnsureTokenIsValid;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::prefix('user')->group(function () {
    Route::post('/login', [UserController::class, 'login']);
    Route::post('/add-user', [UserController::class, 'addUser']);
});

Route::middleware('auth:api')->group(function () {
    Route::post('/commune', [CommuneController::class, 'add']);
    Route::post('/famille', [FamilleController::class, 'add']);
    Route::post('/niveau', [NiveauController::class, 'add']);
});

Route::get('/membre', [MembreController::class, 'fetch']);
Route::post('/uploads', [MembreController::class, 'uploads']);
Route::post('/membre', [MembreController::class, 'add']);
Route::get('/commune', [CommuneController::class, 'fetch']);
Route::get('/niveau', [NiveauController::class, 'fetch']);
Route::get('/famille', [FamilleController::class, 'fetch']);

