<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('membres', function (Blueprint $table) {
            $table->id();
            $table->string("firstname")->nullable();
            $table->string("lastname")->nullable();
            $table->string("quartier")->nullable();
            $table->string("secteur")->nullable();
            $table->string("facebook")->nullable();
            $table->string("qualifications")->nullable();
            $table->string("bapteme")->nullable();
            $table->date("datenaiss")->nullable();
            $table->string("profession")->nullable();
            $table->string("contact")->nullable();
            $table->enum("type_contact", ['Whatsapp', 'Telegramm','Aucun']);

            $table->text('photo')->nullable();

            $table->unsignedBigInteger("commune_id")->nullable();
            $table->unsignedBigInteger("famille_id")->nullable();
            $table->unsignedBigInteger("niveau_id")->nullable();

            $table->foreign('commune_id')->references('id')->on('communes')->onDelete('cascade');
            $table->foreign('famille_id')->references('id')->on('familles')->onDelete('cascade');
            $table->foreign('niveau_id')->references('id')->on('niveaus')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('membres');
    }
};
