<?php

namespace App\Http\Controllers;

use App\Http\Resources\MembreResource;
use App\Models\Membre;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class MembreController extends Controller
{
    //
    public function add(Request $request)
    {
        $filename = null;

        $validator = Validator::make($request->all(), [
            'firstname' => 'required',
            'lastname' => 'required',
            'quartier' => 'required',
            'secteur' => 'required',
            'facebook' => 'required',
            'qualifications' => 'required',
            'bapteme' => 'required',
            'datenaiss' => 'required',
            'profession' => 'required',
            'contact' => 'required',
            'type_contact' => 'required',
            'commune_id'  => 'required',
            'famille_id'  => 'required',
            'niveau_id'  => 'required',
        ]);


        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }

        $membre = $request->all();

        if ($request->hasFile('photo')) {
            $file = $request->file('photo');
            $filename = time() . $file->getClientOriginalName();
            $file->move('uploads', $filename);

            $membre['photo'] = $filename;
        }

        return  Membre::create($membre);
    }

    public function fetch()
    {
        return Membre::get();
    }

    public function uploads () {
        return response(['ok']);
    }
}
